<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:landxml="http://www.landxml.org/schema/LandXML-1.2" xmlns:hexagon="http://xml.hexagon.com/schema/HeXML-1.7" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" version="1.0" encoding="UTF-16" indent="no" omit-xml-declaration="yes"/>
																						
<!-- RW 1-11-17, Version2.0   -->
                                                                                      
<xsl:variable name="XML" select="/"/>
<xsl:variable name="fileExt" select="'csv'"/>
<xsl:variable name="fileDesc" select="'Output STNpointno, STN_E, STN_N, STN_Z, IH, Targetpointno, HA, VA, SD, TH. Angles are DMS'"/>



<xsl:template match="/">
    <xsl:text>STNpointno, STN_E, STN_N, STN_Z, IH, Targetpointno, HA, VA, SD, TH</xsl:text>
    <xsl:text>&#10;</xsl:text>   <!-- new line -->
    
        <xsl:for-each select="$XML">
	    <xsl:for-each select="landxml:LandXML">

        
        <xsl:for-each select="landxml:Survey">
            <xsl:for-each select="landxml:ObservationGroup">
			
				

                <xsl:for-each select="landxml:RawObservation">
				
					<xsl:variable name='setupID' select='@setupID'/>  <!--Get setup ID from RawObservation-->
                    <!--Go up 2 levels and get data from InstrumentSetup with matching id-->
					<xsl:variable name='STN' select='../../landxml:InstrumentSetup[@id=$setupID]/@stationName'/>
					<xsl:variable name='IH' select='../../landxml:InstrumentSetup[@id=$setupID]/@instrumentHeight'/>  
					<xsl:variable name='STNcoord_spc' select='../../landxml:InstrumentSetup[@id=$setupID]/landxml:InstrumentPoint'/>
					<xsl:variable name="STN_N" select="number(substring-before($STNcoord_spc, ' '))"/>
					<xsl:variable name="STN_E" select="number(substring-before(substring-after($STNcoord_spc, ' '), ' '))"/>
					<xsl:variable name="STN_Z" select="number(substring-after(substring-after($STNcoord_spc, ' '), ' '))"/>
					
					
                  <xsl:value-of select='$STN'/>
                  <xsl:text>,</xsl:text>
					<xsl:value-of select='format-number($STN_E, "##0.000")'/>
                  <xsl:text>,</xsl:text>
					<xsl:value-of select='format-number($STN_N, "##0.000")'/>
                  <xsl:text>,</xsl:text>
					<xsl:value-of select='format-number($STN_Z, "##0.000")'/>
                  <xsl:text>,</xsl:text>
					<xsl:value-of select='format-number($IH, "##0.000")'/>
					<xsl:text>,</xsl:text>


				
				

                    <xsl:for-each select="landxml:TargetPoint">
                        <xsl:for-each select="@name">
                        <xsl:value-of select="string(.)"/>
                        </xsl:for-each>    
                    </xsl:for-each>
                    <xsl:text>,</xsl:text>
                    
                    
                    
                    <xsl:for-each select="@horizAngle">
                    <xsl:call-template name="DegreesToDecimal"/>
                
                    </xsl:for-each>
                    <xsl:text>,</xsl:text>

                    <xsl:for-each select="@zenithAngle">
                    <xsl:call-template name="DegreesToDecimal"/>
                    </xsl:for-each>
                    <xsl:text>,</xsl:text>

                    <xsl:for-each select="@slopeDistance">
                        <xsl:value-of select='format-number(., "###0.0000")'/>
                    </xsl:for-each>
                    <xsl:text>,</xsl:text>

                    <xsl:for-each select="@targetHeight">
                        <xsl:value-of select='format-number(., "###0.000")'/>
                    </xsl:for-each>
                   
                    
                    
                    <xsl:text>&#10;</xsl:text> <!-- new line -->
                </xsl:for-each>   
            </xsl:for-each>
        </xsl:for-each>
    
        
        
    </xsl:for-each>
    
</xsl:for-each>
    
</xsl:template>
    
 

<xsl:template name="DegreesToDecimal">
    <xsl:param name="DMS" select="."/>

    <xsl:variable name="Degrees" select=
"number(substring-before($DMS, '.'))"/>
    <xsl:variable name="Mins" select=
"number(substring(substring-after($DMS, '.'),1,2))"/>
    <xsl:variable name="Secs" select=
"number(substring(substring-after($DMS, '.'),3,2))"/>
    <xsl:variable name="DecimalSecs" select=
"number(concat('0.',substring(substring-after($DMS, '.'),5)))"/>
    

    <xsl:value-of select='format-number(
                  
$Degrees
+
$Mins div 60
+
$Secs div 3600
+
$DecimalSecs div 3600                  
                  
, "###0.000000")'
    />
</xsl:template>

</xsl:stylesheet>